#----------------------------------------------------------------------
#  OpenGFDM helping script - build LS matrix programmatically
#  Author: Andrea Pavan
#  Date: 14/12/2022
#  License: GPLv3-or-later
#----------------------------------------------------------------------
using Symbolics;

@variables a,b,c,d,e,f,g,h,i;
@variables x,y,z,w;
B = ((a*x + b*y + c*z + d*x^2 + e*y^2 + f*z^2 + g*x*y + h*x*z + i*y*z)*w)^2;

Da = Differential(a);
Db = Differential(b);
Dc = Differential(c);
Dd = Differential(d);
De = Differential(e);
Df = Differential(f);
Dg = Differential(g);
Dh = Differential(h);
Di = Differential(i);
A = Symbolics.jacobian([Da(B),Db(B),Dc(B),Dd(B),De(B),Df(B),Dg(B),Dh(B),Di(B)],[a,b,c,d,e,f,g,h,i]);

Astr = string.(A);
Astr = replace.(Astr, "^2"=>"^TWO");
Astr = replace.(Astr, "2"=>"");
Astr = replace.(Astr, "^TWO"=>"^2");
Astr = replace.(Astr, "x"=>"xj");
Astr = replace.(Astr, "y"=>"yj");
Astr = replace.(Astr, "z"=>"zj");
Astr = replace.(Astr, "w^2"=>"w2[i]");
Astr = replace.(Astr, "*"=>".*");
Astr = replace.(Astr, "^"=>".^");
Astr = "sum(".*Astr.*")";
Base.print_matrix(stdout,Astr);
